/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BeeSpawningRecipe
implements Recipe<Container> {
    public final ResourceLocation id;
    public final Ingredient ingredient;
    public final List<Lazy<BeeIngredient>> output;
    public final List<String> biomes;
    public final String temperature;

    public BeeSpawningRecipe(ResourceLocation id, Ingredient ingredient, List<Lazy<BeeIngredient>> output, List<String> biomes, String temperature) {
        this.id = id;
        this.ingredient = ingredient;
        this.output = output;
        this.biomes = biomes;
        this.temperature = temperature;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        ItemStack inventoryItem = null;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack itemstack = inv.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            if (inventoryItem != null) {
                return false;
            }
            inventoryItem = itemstack;
        }
        return this.matches(inventoryItem);
    }

    public boolean matches(ItemStack nest) {
        return this.ingredient.test(nest);
    }

    @Nonnull
    public ItemStack m_5874_(Container inv) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.BEE_SPAWNING.get();
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return ModRecipeTypes.BEE_SPAWNING_TYPE;
    }

    public static class Serializer<T extends BeeSpawningRecipe>
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        @Nonnull
        public T fromJson(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = GsonHelper.m_13885_((JsonObject)json, (String)"ingredient") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"ingredient")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"ingredient"));
            JsonArray jsonArray = GsonHelper.m_13933_((JsonObject)json, (String)"results");
            ArrayList<Lazy<BeeIngredient>> output = new ArrayList<Lazy<BeeIngredient>>();
            jsonArray.forEach(el -> {
                JsonObject jsonObject = el.getAsJsonObject();
                String beeName = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"bee");
                Lazy beeIngredient = Lazy.of(BeeIngredientFactory.getIngredient(beeName));
                output.add(beeIngredient);
            });
            ArrayList<String> biomes = new ArrayList<String>();
            if (json.has("biomes")) {
                GsonHelper.m_13933_((JsonObject)json, (String)"biomes").forEach(jsonElement -> biomes.add(jsonElement.getAsString()));
            }
            String temperature = json.has("temperature") ? json.get("temperature").getAsString() : "any";
            return this.factory.create(id, ingredient, output, biomes, temperature);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buffer) {
            try {
                Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
                ArrayList<Lazy<BeeIngredient>> output = new ArrayList<Lazy<BeeIngredient>>();
                IntStream.range(0, buffer.readInt()).forEach(i -> {
                    BeeIngredient ing = BeeIngredient.fromNetwork(buffer);
                    output.add(Lazy.of(() -> ing));
                });
                ArrayList<String> biomes = new ArrayList<String>();
                IntStream.range(0, buffer.readInt()).forEach(i -> biomes.add(buffer.m_130277_()));
                String temperature = buffer.m_130277_();
                return this.factory.create(id, ingredient, output, biomes, temperature);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading bee spawning recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, T recipe) {
            try {
                ((BeeSpawningRecipe)recipe).ingredient.m_43923_(buffer);
                buffer.writeInt(((BeeSpawningRecipe)recipe).output.size());
                for (Lazy<BeeIngredient> beeOutput : ((BeeSpawningRecipe)recipe).output) {
                    if (beeOutput.get() != null) {
                        ((BeeIngredient)beeOutput.get()).toNetwork(buffer);
                        continue;
                    }
                    ProductiveBees.LOGGER.error("Bee spawning recipe output missing " + ((BeeSpawningRecipe)recipe).m_6423_() + " - " + beeOutput);
                }
                buffer.writeInt(((BeeSpawningRecipe)recipe).biomes.size());
                ((BeeSpawningRecipe)recipe).biomes.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130070_(arg_0));
                buffer.m_130070_(((BeeSpawningRecipe)recipe).temperature);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing bee spawning recipe to packet. " + ((BeeSpawningRecipe)recipe).m_6423_(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends BeeSpawningRecipe> {
            public T create(ResourceLocation var1, Ingredient var2, List<Lazy<BeeIngredient>> var3, List<String> var4, String var5);
        }
    }
}

